const Express = require('express')
const cors = require('cors')
const BodyParser = require('body-parser')

const app = Express()

app.use(cors())
app.use(BodyParser.json())
app.use(BodyParser.urlencoded({ extended:true }))

const LoginRoute = require('./Routes/LoginRoute')
const PaymentRoute = require('./Routes/PaymentRoutes')
const StudentRoute = require('./Routes/StudentRoute')

app.use('/login',LoginRoute)
app.use('/payment',PaymentRoute)
app.use('/student',StudentRoute)

app.listen(9000,() => console.log('Server started on PORT 9000'))
