const Express = require('express')
const router = Express.Router();
const { FinanceDatabaseConnection } = require('../DatabaseConnection')

router.post('/add',(req,res) => {
    const  { name,admno,course,method,amount,year,date } = req.body;
    const InsertSQL = 'INSERT INTO payments(admno,name,course,method,amount,year,date) VALUES (?,?,?,?,?,?,?)'
    FinanceDatabaseConnection.query(InsertSQL,[admno,name,course,method,amount,year,date],(err,result) => {
        if (err){
            console.log(err)
            return res.json({
                msg:'An error ocurred',
                added:false
            })
        }else {
            return res.json({
                msg:'Payment saved successfully',
                added:true
            })
        }
    })
})
router.get('/all',(req,res) => {
    const SelectSQL = 'SELECT * FROM payments';
    FinanceDatabaseConnection.query(SelectSQL,(err,payments) => {
        if (err){
            console.log(err)
        }else {
            return res.json({
                msg:'Payments Found',
                payments
            })
        }
    })
})
router.get('/search',(req,res) => {
    const { status,course,year } = req.query
    console.log(status,course,year)
    if (status === 'All'){
        const SelectSQL = 'SELECT * FROM payments WHERE course = ?'
        FinanceDatabaseConnection.query(SelectSQL,[course],(err,payments) => {
            if(err){
                console.log(err)
                return res.json({
                    msg:'An error ocurred',

                })
            }else {
                return res.json({
                    msg:`All payments in the ${course} of year ${year} have been found`,
                    payments
                })
            }
        })

    }else if (status ==='Fully Paid'){
        const SelectSQL = 'SELECT * FROM payments WHERE course = ?'
        FinanceDatabaseConnection.query(SelectSQL,[course],(err,payments) => {
            if(err){
                console.log(err)
                return res.json({
                    msg:'An error ocurred',

                })
            }else {
                return res.json({
                    payments
                })
            }
        })

    }else if (status === 'Not Fully Paid'){
        const SelectSQL = 'SELECT * FROM payments WHERE course = ?'
        FinanceDatabaseConnection.query(SelectSQL,[course],(err,payments) => {
            if(err){
                console.log(err)
                return res.json({
                    msg:'An error ocurred',

                })
            }else {
                return res.json({
                    payments
                })
            }
        })
    }

})
router.get('/searchstudent',(req,res) => {
    const admno = req.query.admno
    const selectsql = 'SELECT * FROM payments WHERE admno = ?'
    FinanceDatabaseConnection.query(selectsql,[admno],(err,payments) => {
        if (err){
            console.log(err)
            return res.json({
                msg:'An error occurred'
            })
        }else {
            return res.json({
                msg:'Payments Found',
                payments
            })
        }
    })
})
module.exports = router

const CourseFeesInfo = [
    {
        course:'Internal',
        fees:60500,
    },
    {
        course: 'Artisan',
        fees: 79500,

    },
    {
        course:'Craft',
        fees: 129500
    },
    {
        course: 'Diploma',
        fees: 249350
    }
]
function getCourseFees(course){
    const coursefee = CourseFeesInfo.find((courseitem) => courseitem.course === course)
    return coursefee.fees


}
console.log(getCourseFees('Internal'))
