const Express = require('express')
const router = Express.Router()
const { SchoolDatabaseConnection } = require('../DatabaseConnection')

router.get('/',(req,res) => {
    const admno = req.query.admno
    const SelectSQL = 'SELECT * FROM students WHERE admno= ?'
    SchoolDatabaseConnection.query(SelectSQL,[admno],(err,students) => {
        if (err){
            console.log(err)
            return res.json({
                err,
                msg:'An error ocurred',
                found:false
            })
        }else {
            if (students.length === 0){
                return res.json({
                    msg:'No such student was found',
                    found:false,

                })
            }else {
                return res.json({
                    msg:'Student Found',
                    student:students[0],
                    found:true
                })
            }

        }
    })
})
router.get('/all',(req,res) => {
    const SelectSQL = 'SELECT * FROM students'
    SchoolDatabaseConnection.query(SelectSQL,(err,students) => {
        if (err){
            console.log(err)
            return res.json({
                err,
                msg:'An error ocurred',
                found:false
            })
        }else {
            return res.json({
                msg:'All students Found',
                students
            })

        }
    })
})
module.exports = router
